<?pap

require_once '../core/Controller.php';

class DashboardController extends Controller
{
    private $agentModel;
    private $userModel;
    private $transactionModel;
    private $gameModel;

    public function __construct()
    {
        parent::__construct();
        $this->agentModel = $this->loadModel('Agent');
        $this->userModel = $this->loadModel('User');
        $this->transactionModel = $this->loadModel('Transaction');
        $this->gameModel = $this->loadModel('Game');
    }

    public function index()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $agentCode = $currentAgent['agent_code'];
        
        // Get statistics
        $stats = $this->getStatistics($agentCode, $currentAgent['agent_level']);
        
        return $this->view->render('dashboard.index', [
            'title' => 'Dashboard',
            'agent' => $currentAgent,
            'stats' => $stats,
            'flash' => $this->getFlashMessage()
        ]);
    }

    private function getStatistics($agentCode, $agentLevel)
    {
        $stats = [];
        
        if ($agentLevel === 'admin') {
            // Admin sees all data
            $stats['totalMembers'] = $this->userModel->count();
            $stats['totalBalance'] = $this->userModel->getTotalBalance();
            $stats['totalBetting'] = $this->transactionModel->getTotalBetting();
            $stats['totalAgents'] = $this->agentModel->count();
        } else {
            // Agent sees only their data
            $stats['totalMembers'] = $this->userModel->count(['agent_code' => $agentCode]);
            $stats['totalBalance'] = $this->userModel->getTotalBalance($agentCode);
            $stats['totalBetting'] = $this->transactionModel->getTotalBetting($agentCode);
            $stats['totalAgents'] = $this->agentModel->count(['agent_upline' => $agentCode]);
        }
        
        $stats['totalGames'] = $this->gameModel->count();
        $stats['agentBalance'] = $this->agentModel->getBalance($agentCode);
        
        return $stats;
    }

    public function stats()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $stats = $this->getStatistics($currentAgent['agent_code'], $currentAgent['agent_level']);
        
        return $this->json([
            'status' => 'success',
            'data' => $stats
        ]);
    }
}