<?php
// app/Controllers/GameController.php - Game Management Controller

require_once '../core/Controller.php';

class GameController extends Controller
{
    private $gameModel;

    public function __construct()
    {
        parent::__construct();
        $this->gameModel = $this->loadModel('Game');
    }

    public function providers()
    {
        $this->requireAuth();
        
        $providers = $this->gameModel->getProviders();
        
        return $this->view->render('games.providers', [
            'title' => 'Game Providers',
            'providers' => $providers,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function gameList()
    {
        $this->requireAuth();
        
        $games = $this->gameModel->getActiveGames();
        $stats = $this->gameModel->getGameStats();
        
        return $this->view->render('games.list', [
            'title' => 'Game List',
            'games' => $games,
            'stats' => $stats,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function syncGames()
    {
        $this->requireAuth();
        
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            return $this->json(['status' => 'error', 'message' => 'Invalid request method']);
        }

        // Mock sync process - in real implementation, this would call external API
        $mockGames = [
            [
                'game_code' => 'vs20olympgate',
                'game_name' => 'Gates of Olympus',
                'game_provider' => 'PRAGMATIC',
                'game_type' => 'slot',
                'game_image' => 'https://example.com/games/olympgate.jpg',
                'game_status' => 1
            ],
            [
                'game_code' => 'mahjong-ways2',
                'game_name' => 'Mahjong Ways 2',
                'game_provider' => 'PGSOFT',
                'game_type' => 'slot',
                'game_image' => 'https://example.com/games/mahjong2.jpg',
                'game_status' => 1
            ]
        ];

        $synced = 0;
        foreach ($mockGames as $gameData) {
            if ($this->gameModel->syncGame($gameData)) {
                $synced++;
            }
        }

        return $this->json([
            'status' => 'success',
            'message' => "Synced {$synced} games successfully"
        ]);
    }
}