<?php
// app/Middleware/ApiAuth.php - API Authentication Middleware

class ApiAuth
{
    public function handle()
    {
        $agentToken = $_GET['agent_token'] ?? $_POST['agent_token'] ?? '';
        $agentCode = $_GET['agent_code'] ?? $_POST['agent_code'] ?? '';
        
        if (empty($agentToken) || empty($agentCode)) {
            http_response_code(401);
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'fail',
                'message' => 'Missing authentication parameters'
            ]);
            exit();
        }
        
        // Load agent model to verify credentials
        require_once '../app/Models/Agent.php';
        $agentModel = new Agent();
        
        $agent = $agentModel->findBy('agent_code', $agentCode);
        if (!$agent || $agent['agent_token'] !== $agentToken) {
            http_response_code(401);
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'fail',
                'message' => 'Invalid authentication credentials'
            ]);
            exit();
        }
        
        if ($agent['agent_status'] === 'blocked') {
            http_response_code(403);
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'fail',
                'message' => 'Agent account is blocked'
            ]);
            exit();
        }
        
        return true;
    }
}