<?php

require_once '../core/Model.php';

class User extends Model
{
    protected $table = 'tb_user';
    protected $primaryKey = 'id';

    public function getTotalBalance($agentCode = null)
    {
        $sql = "SELECT COALESCE(SUM(balance), 0) as total FROM {$this->table}";
        $params = [];
        
        if ($agentCode) {
            $sql .= " WHERE agent_code = ?";
            $params[] = $agentCode;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchColumn();
    }

    public function getByAgent($agentCode)
    {
        return $this->where(['agent_code' => $agentCode], 'created DESC');
    }

    public function createUser($data)
    {
        $userData = [
            'intUser' => $data['intUser'],
            'extUser' => $data['extUser'],
            'password' => $data['password'],
            'balance' => 0,
            'agent_code' => $data['agent_code'],
            'created' => date('Y-m-d H:i:s'),
            'status' => 1
        ];
        
        return $this->create($userData);
    }

    public function updateBalance($username, $newBalance, $agentCode)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET balance = ? WHERE extUser = ? AND agent_code = ?");
        return $stmt->execute([$newBalance, $username, $agentCode]);
    }

    public function addBalance($username, $amount, $agentCode)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET balance = balance + ? WHERE extUser = ? AND agent_code = ?");
        return $stmt->execute([$amount, $username, $agentCode]);
    }

    public function subtractBalance($username, $amount, $agentCode)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET balance = balance - ? WHERE extUser = ? AND agent_code = ? AND balance >= ?");
        return $stmt->execute([$amount, $username, $agentCode, $amount]);
    }

    public function getBettingStats($agentCode = null)
    {
        $sql = "
            SELECT 
                COUNT(*) as total_bets,
                COALESCE(SUM(bet_money), 0) as total_bet_amount,
                COALESCE(SUM(win_money), 0) as total_win_amount
            FROM tb_history h
            JOIN {$this->table} u ON u.intUser = h.intUser
        ";
        $params = [];
        
        if ($agentCode) {
            $sql .= " WHERE u.agent_code = ?";
            $params[] = $agentCode;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetch();
    }
}