<?php
// app/Utils/Helper.php - Helper Functions

class Helper
{
    public static function generateRandomString($length = 8)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        
        return $randomString;
    }

    public static function sanitizeInput($input)
    {
        return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
    }

    public static function validateEmail($email)
    {
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }

    public static function formatCurrency($amount, $currency = 'IDR')
    {
        return $currency . ' ' . number_format($amount, 0, ',', '.');
    }

    public static function timeAgo($datetime)
    {
        $time = time() - strtotime($datetime);
        
        if ($time < 60) return 'just now';
        if ($time < 3600) return floor($time/60) . ' minutes ago';
        if ($time < 86400) return floor($time/3600) . ' hours ago';
        if ($time < 2592000) return floor($time/86400) . ' days ago';
        if ($time < 31104000) return floor($time/2592000) . ' months ago';
        
        return floor($time/31104000) . ' years ago';
    }

    public static function logActivity($message, $data = [])
    {
        $logFile = '../logs/activity.log';
        $logEntry = date('Y-m-d H:i:s') . " - " . $message;
        if (!empty($data)) {
            $logEntry .= " - " . json_encode($data);
        }
        $logEntry .= PHP_EOL;
        
        file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
    }

    public static function isValidPhoneNumber($phone)
    {
        return preg_match('/^(\+62|62|0)8[1-9][0-9]{6,9}$/', $phone);
    }

    public static function maskSensitiveData($data, $start = 3, $end = 3)
    {
        $length = strlen($data);
        if ($length <= $start + $end) return $data;
        
        return substr($data, 0, $start) . str_repeat('*', $length - $start - $end) . substr($data, -$end);
    }
}