<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col">
                        <h4><i class="cil-people"></i> Agent Management</h4>
                    </div>
                    <div class="col-auto">
                        <a href="/agents/create" class="btn btn-primary">
                            <i class="cil-plus"></i> Add New Agent
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="agentsTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Agent Code</th>
                                <th>Agent Name</th>
                                <th>Balance</th>
                                <th>Level</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($agents)): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">No agents found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($agents as $agent): ?>
                                <tr>
                                    <td><?= htmlspecialchars($agent['id']) ?></td>
                                    <td>
                                        <code><?= htmlspecialchars($agent['agent_code']) ?></code>
                                    </td>
                                    <td>
                                        <strong><?= htmlspecialchars($agent['agent_name']) ?></strong>
                                    </td>
                                    <td>
                                        <span class="badge badge-success">
                                            <?= number_format($agent['agent_balance']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?= $agent['agent_level'] === 'admin' ? 'danger' : 'primary' ?>">
                                            <?= strtoupper($agent['agent_level']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?= $agent['agent_status'] === 'active' ? 'success' : 'danger' ?>">
                                            <?= strtoupper($agent['agent_status']) ?>
                                        </span>
                                    </td>
                                    <td><?= date('Y-m-d H:i', strtotime($agent['agent_created'])) ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" onclick="editBalance(<?= $agent['id'] ?>, '<?= $agent['agent_name'] ?>')">
                                                <i class="cil-credit-card"></i>
                                            </button>
                                            <a href="/agents/<?= $agent['id'] ?>/edit" class="btn btn-sm btn-warning">
                                                <i class="cil-pencil"></i>
                                            </a>
                                            <?php if ($agent['agent_status'] === 'active'): ?>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="blockAgent(<?= $agent['id'] ?>)">
                                                <i class="cil-ban"></i>
                                            </button>
                                            <?php else: ?>
                                            <button type="button" class="btn btn-sm btn-success" onclick="unblockAgent(<?= $agent['id'] ?>)">
                                                <i class="cil-check"></i>
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Balance Edit Modal -->
<div class="modal fade" id="balanceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Agent Balance</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form id="balanceForm">
                <div class="modal-body">
                    <input type="hidden" id="agentId" name="agent_id">
                    <div class="form-group">
                        <label>Agent Name</label>
                        <input type="text" class="form-control" id="agentName" readonly>
                    </div>
                    <div class="form-group">
                        <label>Action</label>
                        <select class="form-control" name="action" required>
                            <option value="add">Add Balance</option>
                            <option value="subtract">Subtract Balance</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Amount</label>
                        <input type="number" class="form-control" name="amount" min="1" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editBalance(id, name) {
    $('#agentId').val(id);
    $('#agentName').val(name);
    $('#balanceModal').modal('show');
}

$('#balanceForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const agentId = $('#agentId').val();
    
    fetch(`/agents/${agentId}/balance`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            alert('Balance updated successfully');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error updating balance');
        console.error(error);
    });
});

function blockAgent(id) {
    if (confirm('Are you sure you want to block this agent?')) {
        fetch(`/agents/${id}/block`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert('Agent blocked successfully');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error blocking agent');
            console.error(error);
        });
    }
}

function unblockAgent(id) {
    if (confirm('Are you sure you want to unblock this agent?')) {
        fetch(`/agents/${id}/unblock`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert('Agent unblocked successfully');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error unblocking agent');
            console.error(error);
        });
    }
}
</script>