<div class="row mb-3">
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="h4"><?= $stats['total_games'] ?></div>
                <div>Total Games</div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="h4"><?= $stats['active_games'] ?></div>
                <div>Active Games</div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <div class="h4"><?= $stats['slot_games'] ?></div>
                <div>Slot Games</div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="h4"><?= $stats['live_games'] ?></div>
                <div>Live Games</div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col">
                        <h4><i class="cil-list"></i> Game List</h4>
                    </div>
                    <div class="col-auto">
                        <button class="btn btn-success" onclick="syncGames()">
                            <i class="cil-reload"></i> Sync Games
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Game Code</th>
                                <th>Game Name</th>
                                <th>Provider</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($games)): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">No games found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($games as $game): ?>
                                <tr>
                                    <td><code><?= htmlspecialchars($game['game_code']) ?></code></td>
                                    <td><?= htmlspecialchars($game['game_name']) ?></td>
                                    <td><span class="badge badge-info"><?= htmlspecialchars($game['game_provider']) ?></span></td>
                                    <td><?= strtoupper($game['game_type']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $game['game_status'] ? 'success' : 'danger' ?>">
                                            <?= $game['game_status'] ? 'Active' : 'Inactive' ?>
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" onclick="testGame('<?= $game['game_code'] ?>')">
                                            <i class="cil-media-play"></i> Test
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function syncGames() {
    if (confirm('Sync games from API?')) {
        fetch('/games/sync', { method: 'POST' })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.status === 'success') {
                    location.reload();
                }
            });
    }
}

function testGame(gameCode) {
    alert('Test game: ' + gameCode);
}
</script>