<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col">
                        <h4><i class="cil-gamepad"></i> Game Providers</h4>
                    </div>
                    <div class="col-auto">
                        <button class="btn btn-primary" onclick="syncProviders()">
                            <i class="cil-reload"></i> Sync Providers
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if (empty($providers)): ?>
                    <div class="col-12">
                        <div class="text-center text-muted py-4">No providers found</div>
                    </div>
                    <?php else: ?>
                        <?php foreach ($providers as $provider): ?>
                        <div class="col-sm-6 col-lg-3 mb-3">
                            <div class="card">
                                <div class="card-body text-center">
                                    <div class="h4 text-primary"><?= htmlspecialchars($provider['game_provider']) ?></div>
                                    <div class="text-muted"><?= ucwords(str_replace('_', ' ', $provider['game_provider'])) ?></div>
                                    <div class="mt-2">
                                        <span class="badge badge-success">Active</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function syncProviders() {
    if (confirm('Sync game providers from API?')) {
        fetch('/games/sync', { method: 'POST' })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.status === 'success') {
                    location.reload();
                }
            });
    }
}
</script>