<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><i class="cil-history"></i> Transaction History</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Transaction Count</th>
                                <th>Total Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($dailyTransactions)): ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted py-4">No transaction history found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($dailyTransactions as $daily): ?>
                                <tr>
                                    <td><?= htmlspecialchars($daily['date']) ?></td>
                                    <td><?= number_format($daily['count']) ?></td>
                                    <td><?= number_format($daily['total']) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>