<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col">
                        <h4><i class="cil-people"></i> Online Users & RTP Control</h4>
                    </div>
                    <div class="col-auto">
                        <button class="btn btn-primary" onclick="refreshOnlineUsers()">
                            <i class="cil-reload"></i> Refresh
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="onlineUsersTable">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Provider</th>
                                <th>Game</th>
                                <th>Bet</th>
                                <th>Balance</th>
                                <th>Target RTP</th>
                                <th>Real RTP</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="onlineUsersBody">
                            <?php
                            // Get online users from Nexus Gaming API
                            require_once '../app/Services/NexusGamingApi.php';
                            $currentAgent = $_SESSION['admin'];
                            $api = new NexusGamingApi($currentAgent['agent_code'], $currentAgent['agent_token']);
                            
                            $onlineUsers = $api->getCallPlayers();
                            
                            if ($onlineUsers['status'] == 1 && isset($onlineUsers['data'])):
                                foreach ($onlineUsers['data'] as $player):
                                    // Get user info from local database
                                    $userInfo = $userModel->findBy('intUser', $player['user_code']);
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($userInfo['extUser'] ?? $player['user_code']) ?></td>
                                <td><span class="badge badge-info"><?= htmlspecialchars($player['provider_code']) ?></span></td>
                                <td><?= htmlspecialchars($player['game_code']) ?></td>
                                <td><?= number_format($player['bet']) ?></td>
                                <td><?= number_format($player['balance']) ?></td>
                                <td><?= $player['target_rtp'] ?>%</td>
                                <td><?= number_format($player['real_rtp'], 2) ?>%</td>
                                <td>
                                    <button class="btn btn-sm btn-warning" onclick="showRtpModal('<?= $player['user_code'] ?>', '<?= $player['provider_code'] ?>', '<?= $player['game_code'] ?>')">
                                        <i class="cil-settings"></i> Set RTP
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; else: ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">No online users found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- RTP Control Modal -->
<div class="modal fade" id="rtpModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Control User RTP</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form id="rtpForm">
                <div class="modal-body">
                    <input type="hidden" id="rtpUserCode" name="user_code">
                    <input type="hidden" id="rtpProviderCode" name="provider_code">
                    <input type="hidden" id="rtpGameCode" name="game_code">
                    
                    <div class="form-group">
                        <label>User Code</label>
                        <input type="text" class="form-control" id="rtpUserDisplay" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Provider</label>
                        <input type="text" class="form-control" id="rtpProviderDisplay" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Game Code</label>
                        <input type="text" class="form-control" id="rtpGameDisplay" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>New RTP (%)</label>
                        <input type="number" class="form-control" name="rtp" min="1" max="95" required>
                        <small class="form-text text-muted">RTP must be between 1-95%</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">Update RTP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function refreshOnlineUsers() {
    location.reload();
}

function showRtpModal(userCode, providerCode, gameCode) {
    $('#rtpUserCode').val(userCode);
    $('#rtpProviderCode').val(providerCode);
    $('#rtpGameCode').val(gameCode);
    $('#rtpUserDisplay').val(userCode);
    $('#rtpProviderDisplay').val(providerCode);
    $('#rtpGameDisplay').val(gameCode);
    $('#rtpModal').modal('show');
}

$('#rtpForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const requestData = {
        user_code: formData.get('user_code'),
        provider_code: formData.get('provider_code'),
        game_code: formData.get('game_code'),
        rtp: parseInt(formData.get('rtp'))
    };
    
    fetch('/users/control-rtp', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(requestData)
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            alert('RTP updated successfully');
            $('#rtpModal').modal('hide');
            refreshOnlineUsers();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error updating RTP');
        console.error(error);
    });
});
</script>