<?php

class Application
{
    private $router;
    private $database;
    private $basePath = '/';
    private $defaultController = 'Dashboard';
    private $defaultAction = 'index';

    public function __construct()
    {
        $this->router = new Router();
        $this->database = new Database();
        $this->initializeSession();
    }

    public function setBasePath($path)
    {
        $this->basePath = $path;
    }

    public function setDefaultController($controller)
    {
        $this->defaultController = $controller;
    }

    public function setDefaultAction($action)
    {
        $this->defaultAction = $action;
    }

    private function initializeSession()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        date_default_timezone_set("Asia/Jakarta");
    }

    public function run()
    {
        try {
            // Get current request
            $uri = $_SERVER['REQUEST_URI'];
            $method = $_SERVER['REQUEST_METHOD'];
            
            // Remove base path and query parameters
            $uri = parse_url($uri, PHP_URL_PATH);
            $uri = str_replace($this->basePath, '', $uri);
            $uri = trim($uri, '/');

            // Route the request
            $result = $this->router->route($method, $uri);

            if ($result) {
                echo $result;
            } else {
                $this->handle404();
            }
        } catch (Exception $e) {
            $this->handleError($e);
        }
    }

    private function handle404()
    {
        http_response_code(404);
        include '../app/Views/errors/404.php';
    }

    private function handleError($exception)
    {
        http_response_code(500);
        if ($_ENV['APP_DEBUG'] ?? false) {
            echo "<h1>Error: " . $exception->getMessage() . "</h1>";
            echo "<pre>" . $exception->getTraceAsString() . "</pre>";
        } else {
            include '../app/Views/errors/500.php';
        }
    }
}