<?php

class Controller
{
    protected $model;
    protected $view;
    
    public function __construct()
    {
        $this->view = new View();
    }

    protected function loadModel($modelName)
    {
        $modelFile = "../app/Models/{$modelName}.php";
        if (file_exists($modelFile)) {
            require_once $modelFile;
            return new $modelName();
        }
        throw new Exception("Model {$modelName} not found");
    }

    protected function redirect($url)
    {
        header("Location: {$url}");
        exit();
    }

    protected function json($data, $statusCode = 200)
    {
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data, JSON_PRETTY_PRINT);
        exit();
    }

    protected function isAuthenticated()
    {
        return isset($_SESSION['admin']) && !empty($_SESSION['admin']);
    }

    protected function requireAuth()
    {
        if (!$this->isAuthenticated()) {
            $this->redirect('/login');
        }
    }

    protected function setFlashMessage($type, $title, $message)
    {
        $_SESSION['flash'] = [
            'type' => $type,
            'title' => $title,
            'message' => $message
        ];
    }

    protected function getFlashMessage()
    {
        if (isset($_SESSION['flash'])) {
            $flash = $_SESSION['flash'];
            unset($_SESSION['flash']);
            return $flash;
        }
        return null;
    }
}