<?php

class View
{
    private $viewPath = '../app/Views/';
    private $layoutPath = '../app/Views/layouts/';
    private $data = [];

    public function render($view, $data = [], $layout = 'main')
    {
        $this->data = array_merge($this->data, $data);
        
        // Start output buffering
        ob_start();
        
        // Extract data to variables
        extract($this->data);
        
        // Include the view file
        $viewFile = $this->viewPath . str_replace('.', '/', $view) . '.php';
        if (file_exists($viewFile)) {
            include $viewFile;
        } else {
            throw new Exception("View {$view} not found");
        }
        
        // Get the view content
        $content = ob_get_clean();
        
        // If layout is specified, wrap content in layout
        if ($layout) {
            $layoutFile = $this->layoutPath . $layout . '.php';
            if (file_exists($layoutFile)) {
                ob_start();
                include $layoutFile;
                return ob_get_clean();
            } else {
                throw new Exception("Layout {$layout} not found");
            }
        }
        
        return $content;
    }

    public function partial($partial, $data = [])
    {
        $this->data = array_merge($this->data, $data);
        extract($this->data);
        
        $partialFile = $this->viewPath . 'partials/' . $partial . '.php';
        if (file_exists($partialFile)) {
            include $partialFile;
        } else {
            throw new Exception("Partial {$partial} not found");
        }
    }

    public function set($key, $value = null)
    {
        if (is_array($key)) {
            $this->data = array_merge($this->data, $key);
        } else {
            $this->data[$key] = $value;
        }
    }
}