<?php
// cron/cleanup-logs.php - Clean old log files and data

require_once '../core/Database.php';

// Set timezone
date_default_timezone_set('Asia/Jakarta');

$db = Database::getInstance()->getConnection();

echo "[" . date('Y-m-d H:i:s') . "] Starting cleanup process...\n";

try {
    // Clean old history records (older than 90 days)
    $stmt = $db->prepare("DELETE FROM tb_history WHERE created_at < DATE_SUB(NOW(), INTERVAL 90 DAY)");
    $stmt->execute();
    $deletedHistory = $stmt->rowCount();
    
    // Clean old transaction records (older than 1 year)
    $stmt = $db->prepare("DELETE FROM tb_transaction WHERE created < DATE_SUB(NOW(), INTERVAL 1 YEAR)");
    $stmt->execute();
    $deletedTransactions = $stmt->rowCount();
    
    // Clean log files
    $logDir = '../logs/';
    $logFiles = glob($logDir . '*.log');
    $cleanedLogs = 0;
    
    foreach ($logFiles as $logFile) {
        if (filemtime($logFile) < strtotime('-30 days')) {
            if (unlink($logFile)) {
                $cleanedLogs++;
            }
        }
    }
    
    // Optimize database tables
    $tables = ['tb_history', 'tb_transaction', 'tb_user', 'tb_agent'];
    foreach ($tables as $table) {
        $db->exec("OPTIMIZE TABLE $table");
    }
    
    echo "[" . date('Y-m-d H:i:s') . "] Cleanup completed:\n";
    echo "  - Deleted {$deletedHistory} old history records\n";
    echo "  - Deleted {$deletedTransactions} old transaction records\n";
    echo "  - Cleaned {$cleanedLogs} old log files\n";
    echo "  - Optimized database tables\n";

} catch (Exception $e) {
    echo "[" . date('Y-m-d H:i:s') . "] ERROR: " . $e->getMessage() . "\n";
    
    // Log to file
    file_put_contents('../logs/cleanup.log', date('Y-m-d H:i:s') . " ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
}