<?php
// cron/sync-history.php - Auto sync betting history from external API

require_once '../core/Database.php';
require_once '../app/Models/User.php';

// Set timezone
date_default_timezone_set('Asia/Jakarta');

// Initialize models
$userModel = new User();
$db = Database::getInstance()->getConnection();

// Log start
echo "[" . date('Y-m-d H:i:s') . "] Starting history sync...\n";

try {
    // Get all users for history sync
    $users = $userModel->all();
    $syncedCount = 0;

    foreach ($users as $user) {
        // Mock external API call for user history - replace with actual API
        $mockHistory = [
            [
                'intUser' => $user['intUser'],
                'extUser' => $user['extUser'],
                'bet_money' => rand(1000, 50000),
                'win_money' => rand(0, 100000),
                'provider_code' => 'PRAGMATIC',
                'game_code' => 'vs20olympgate',
                'type' => 'BASE',
                'txn_id' => 'TXN' . time() . rand(100, 999),
                'txn_type' => 'debit',
                'user_start_balance' => $user['balance'],
                'user_end_balance' => $user['balance'] - rand(1000, 50000),
                'created_at' => date('Y-m-d H:i:s'),
                'agent_code' => $user['agent_code']
            ]
        ];

        foreach ($mockHistory as $history) {
            // Check if history already exists
            $stmt = $db->prepare("SELECT * FROM tb_history WHERE txn_id = ? AND intUser = ?");
            $stmt->execute([$history['txn_id'], $history['intUser']]);
            
            if ($stmt->rowCount() === 0) {
                $insertStmt = $db->prepare("
                    INSERT INTO tb_history (intUser, extUser, bet_money, win_money, provider_code, game_code, type, txn_id, txn_type, user_start_balance, user_end_balance, created_at, agent_code) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                if ($insertStmt->execute([
                    $history['intUser'], $history['extUser'], $history['bet_money'], $history['win_money'],
                    $history['provider_code'], $history['game_code'], $history['type'], $history['txn_id'],
                    $history['txn_type'], $history['user_start_balance'], $history['user_end_balance'],
                    $history['created_at'], $history['agent_code']
                ])) {
                    $syncedCount++;
                }
            }
        }
    }

    echo "[" . date('Y-m-d H:i:s') . "] History sync completed. Synced: {$syncedCount} records\n";

} catch (Exception $e) {
    echo "[" . date('Y-m-d H:i:s') . "] ERROR: " . $e->getMessage() . "\n";
    
    // Log to file
    file_put_contents('../logs/sync-history.log', date('Y-m-d H:i:s') . " ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
}