<?php
// cron/update-balances.php - Update user balances from external API

require_once '../core/Database.php';
require_once '../app/Models/User.php';
require_once '../app/Models/Agent.php';

// Set timezone
date_default_timezone_set('Asia/Jakarta');

// Initialize models
$userModel = new User();
$agentModel = new Agent();

echo "[" . date('Y-m-d H:i:s') . "] Starting balance update...\n";

try {
    // Get all users
    $users = $userModel->all();
    $updatedCount = 0;

    foreach ($users as $user) {
        // Get real balance from Nexus Gaming API
        require_once '../app/Services/NexusGamingApi.php';
        $api = new NexusGamingApi($user['agent_code'], ''); // Agent token will be fetched from DB
        
        // Get agent token for API calls
        $agent = $agentModel->findBy('agent_code', $user['agent_code']);
        if ($agent) {
            $api = new NexusGamingApi($agent['agent_code'], $agent['agent_token']);
            $balanceInfo = $api->getMoneyInfo($user['intUser']);
            
            if ($balanceInfo['status'] == 1 && isset($balanceInfo['user']['balance'])) {
                $externalBalance = $balanceInfo['user']['balance'];
                
                // Update only if balance is different
                if ($user['balance'] != $externalBalance) {
                    if ($userModel->update($user['id'], ['balance' => $externalBalance])) {
                        $updatedCount++;
                        echo "[" . date('Y-m-d H:i:s') . "] Updated balance for user: " . $user['extUser'] . " -> " . number_format($externalBalance) . "\n";
                    }
                }
            }
        }
    }

    // Update agent balances from external API
    $agents = $agentModel->all();
    $updatedAgents = 0;

    foreach ($agents as $agent) {
        // Mock external API call - replace with actual API
        $externalAgentBalance = rand(1000000, 10000000);
        
        if ($agent['agent_balance'] != $externalAgentBalance) {
            if ($agentModel->update($agent['id'], ['agent_balance' => $externalAgentBalance])) {
                $updatedAgents++;
                echo "[" . date('Y-m-d H:i:s') . "] Updated agent balance: " . $agent['agent_code'] . " -> " . number_format($externalAgentBalance) . "\n";
            }
        }
    }

    echo "[" . date('Y-m-d H:i:s') . "] Balance update completed:\n";
    echo "  - Updated {$updatedCount} user balances\n";
    echo "  - Updated {$updatedAgents} agent balances\n";

} catch (Exception $e) {
    echo "[" . date('Y-m-d H:i:s') . "] ERROR: " . $e->getMessage() . "\n";
    
    // Log to file
    file_put_contents('../logs/update-balances.log', date('Y-m-d H:i:s') . " ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
}